/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.GridDrawable;
import java.awt.Color;

public class BinGrid
implements Customizer {
    boolean multiRow_;
    double pad_;
    double y_;
    Transform3D trans_;

    public BinGrid(boolean multiRow, double pad, double y, Transform3D trans) {
        this.multiRow_ = multiRow;
        this.pad_ = pad;
        this.y_ = y;
        this.trans_ = trans;
    }

    public BinGrid(boolean multiRow) {
        this(multiRow, 0.25, 0.0, new Transform3D());
    }

    public Drawable getDrawable(ChartProperties properties, DataModel model) {
        int rows = this.multiRow_ ? model.getRowCount() : 1;
        int columns = model.getColumnCount();
        double halfDepth = (double)rows / 2.0 + this.pad_;
        double halfWidth = (double)columns / 2.0;
        Line3D[] lines = new Line3D[4 + rows - 1 + columns - 1];
        int index = 0;
        lines[index++] = new Line3D(new Point3D(-halfWidth, this.y_, -halfDepth), new Point3D(-halfWidth, this.y_, halfDepth)).transform(this.trans_);
        lines[index++] = new Line3D(new Point3D(-halfWidth, this.y_, halfDepth), new Point3D(halfWidth, this.y_, halfDepth)).transform(this.trans_);
        lines[index++] = new Line3D(new Point3D(halfWidth, this.y_, halfDepth), new Point3D(halfWidth, this.y_, -halfDepth)).transform(this.trans_);
        lines[index++] = new Line3D(new Point3D(halfWidth, this.y_, -halfDepth), new Point3D(-halfWidth, this.y_, -halfDepth)).transform(this.trans_);
        double z = (double)(-rows) / 2.0 + 1.0;
        for (int i = 1; i < rows; ++i) {
            lines[index++] = new Line3D(new Point3D(-halfWidth, this.y_, z), new Point3D(halfWidth, this.y_, z)).transform(this.trans_);
            z += 1.0;
        }
        double x = -halfWidth + 1.0;
        for (int i = 1; i < columns; ++i) {
            lines[index++] = new Line3D(new Point3D(x, this.y_, -halfDepth), new Point3D(x, this.y_, halfDepth)).transform(this.trans_);
            x += 1.0;
        }
        Color gridColor = (Color)properties.getProperty("GridColor", Color.black);
        return new GridDrawable(lines, gridColor);
    }
}

